<?php
error_reporting(0);
ob_start();

$ip = $_SERVER['HTTP_CF_CONNECTING_IP'] ?? $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['REMOTE_ADDR'];
$blacklistFile = 'blacklist.txt';
$errorLogFile = 'errorpaid.txt';
$debugLogFile = 'debug_log.txt';

// Daftar domain/link redirect
$redirectLinks = [
    'https://www.google.com',
    'https://bbc.com',
    'https://cnn.com',
    'https://nytimes.com',
    'https://reuters.com',
    'https://aljazeera.com',
    'https://theguardian.com',
    'https://wsj.com',
    'https://forbes.com',
    'https://bloomberg.com',
    'https://npr.org',
    'https://abcnews.go.com',
    'https://cnbc.com',
    'https://marketwatch.com',
    'https://time.com',
    'https://usatoday.com',
    'https://msnbc.com',
    'https://huffpost.com',
    'https://newsweek.com',
    'https://thehill.com',
    'https://latimes.com',
    'https://news.ycombinator.com',
    'https://vox.com',
    'https://dailybeast.com',
    'https://businessinsider.com',
    'https://investing.com',
    'https://theverge.com',
    'https://buzzfeednews.com',
    'https://example.com',
    'https://openai.com',
    'https://github.com',
    'https://stackoverflow.com',
    'https://reddit.com',
    'https://twitter.com',
    'https://linkedin.com',
    'https://medium.com',
    'https://quora.com',
    'https://producthunt.com',
    'https://techcrunch.com',
    'https://entrepreneur.com',
    'https://mashable.com',
    'https://buzzfeed.com',
    'https://lifehacker.com',
    'https://cnet.com',
    'https://wired.com',
    'https://theatlantic.com',
    'https://fortune.com',
    'https://wsj.com',
    'https://cnbc.com',
    'https://npr.org'
];

// Fungsi redirect ke link acak
function redirectToRandomLink($links) {
    $randomLink = $links[array_rand($links)];
    header("Location: $randomLink");
    exit;
}

// Baca IP yang sudah di-blacklist
$blacklistedIps = file_exists($blacklistFile) 
    ? file($blacklistFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) 
    : [];

// Langsung redirect jika IP sudah masuk blacklist
if (in_array($ip, $blacklistedIps)) {
    redirectToRandomLink($redirectLinks);
}

// Mulai deteksi IP dengan API
$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => "https://netdetective.p.rapidapi.com/query?ipaddress=$ip",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 10,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_HTTPHEADER => [
        "x-rapidapi-host: netdetective.p.rapidapi.com",
        "x-rapidapi-key: 75e8453762msh7468ac30ace46f0p1c87e1jsnd0f151ae82f3"
    ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

// Tulis log untuk debugging
file_put_contents($debugLogFile, "IP: $ip\nResponse: $response\n\n", FILE_APPEND);

// Jika error, catat ke errorpaid.txt
if ($err) {
    file_put_contents($errorLogFile, "cURL Error: $err\nIP: $ip\n", FILE_APPEND);
    exit;
}

// Proses JSON response
$data = json_decode($response, true);

if (!$data || !isset($data['result'])) {
    file_put_contents($errorLogFile, "Invalid or empty API response for IP: $ip\n", FILE_APPEND);
    exit;
}

// Evaluasi apakah terdeteksi aktivitas mencurigakan
$flags = $data['result'];

$isSuspicious = (
    $flags['isVpn'] ||
    $flags['isDataCenter'] ||
    $flags['isBruteForce'] ||
    $flags['isSpam'] ||
    $flags['isBogon'] ||
    $flags['isZombie'] ||
    $flags['isCompromised'] ||
    $flags['isProxyHttp'] ||
    $flags['isProxySocks'] ||
    $flags['isDDos']
);

if ($isSuspicious) {
    if (!in_array($ip, $blacklistedIps)) {
        file_put_contents($blacklistFile, $ip . PHP_EOL, FILE_APPEND);
    }
    redirectToRandomLink($redirectLinks);
}

ob_end_flush();
?>
