<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

$files = [
    'creditcards.json',
    'db.json',
    'ip.json'
];

$reset_success = [];
$reset_failed = [];

foreach ($files as $file) {
    $dir = dirname($file);

    // Buat folder jika belum ada
    if (!is_dir($dir)) {
        if (!mkdir($dir, 0777, true)) {
            $reset_failed[] = $file . " (mkdir failed)";
            continue;
        }
    }

    // Tulis array kosong ke file
    $result = file_put_contents($file, json_encode([], JSON_PRETTY_PRINT));

    // Verifikasi ulang isi file setelah ditulis
    $verify = json_decode(@file_get_contents($file), true);
    if ($result !== false && is_array($verify) && empty($verify)) {
        $reset_success[] = $file;
    } else {
        $reset_failed[] = $file . " (write or verify failed)";
    }
}

$response = [
    "status" => empty($reset_failed) ? "reset_done" : "partial_failed",
    "success" => $reset_success,
    "failed" => $reset_failed
];

echo json_encode($response, JSON_PRETTY_PRINT);
